
;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   CMPPRG_1.asm
;;  Version: 3.3, Updated on 2006/04/28 at 14:39:41
;;  Generated by PSoC Designer ver 4.3  b1884 : 23 June, 2006
;;
;;  DESCRIPTION: CMPPRG User Module software implementation file
;;               for CY8C22/24/27/29xxx and related devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2002-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************
include "CMPPRG_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  CMPPRG_1_Start
export _CMPPRG_1_Start

export  CMPPRG_1_SetPower
export _CMPPRG_1_SetPower

export  CMPPRG_1_SetRef
export _CMPPRG_1_SetRef

export  CMPPRG_1_Stop
export _CMPPRG_1_Stop

;; -----------------------------------------------------------------
;;                         Register Definitions
;; -----------------------------------------------------------------
;;
;; Uses 1 Continuous Time Block configured as shown. This API depends
;; on knowing the exact personalization of CR0 and CR2 bitfields
;; for time efficiency.
;;
;; * For a Mask/Val pair, this indicates that the value is
;;   determined by the user either through config-time parameteriza-
;;   tion or run-time manipulation.
;;
;; BIT FIELD             Mask/Val Function
;; -----------------            -----   --------------------
;; COMP_CR0.RES_RATIO_T2B       F0/*    User Parameter (by table)
;; COMP_CR0.GAIN_ATTEN          08/0    Gain
;; COMP_CR0.RES_SOURCE          04/0    Res source VDD
;; COMP_CR0.RES_REF             03/*    User Parameter
;;
;; COMP_CR1.A_OUT               80/0    Output bus disabled
;; COMP_CR1.COMP_EN             40/*    User Parameter (init: ENABLE)
;; COMP_CR1.CT_NEG_INPUT_MUX    38/4    Neg mux to analog f.b. tap
;; COMP_CR1.CT_POS_INPUT_MUX    07/*    User Parameter (Input selection)
;;
;; COMP_CR2.CP_COMP             80/0    Latch transparent on PH1
;; COMP_CR2.CK_COMP             40/0    Latch transparent
;; COMP_CR2.CC_COMP             20/0    Mode Comparator (not OP-amp)
;; COMP_CR2.BYPASS_OBUS         1C/0    Bypass OFF
;; COMP_CR2.PWR_SELECT          03/0    Power OFF at start-up


;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
POWERMASK:    equ 03h
REFMASK:      equ f0h
GAINMASK:     equ f4h
EXGAIN:       equ 01h
HIGHGAIN:     equ 04h
HIGHGAINMASK: equ 10h


AREA UserModules (ROM, REL)
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CMPPRG_1_Start
;  FUNCTION NAME: CMPPRG_1_SetPower
;
;  DESCRIPTION:
;    Applies power setting to the module's PSoC blocks
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the power setting 0=Off, 1=Low, 2=Med, 3=High
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 CMPPRG_1_Start:
_CMPPRG_1_Start:
 CMPPRG_1_SetPower:
_CMPPRG_1_SetPower:

   RAM_PROLOGUE RAM_USE_CLASS_2
   and A, POWERMASK                             ; mask A to protect unchanged bits
   mov X, SP                                    ; define temp store location

   push A                                       ; put power value in temp store
   mov A, reg[CMPPRG_1_COMP_CR2]                  ; read power value
   and A, ~POWERMASK                            ; clear power bits in A
   or  A, [X]                                   ; combine power value with balance of reg.
   mov reg[CMPPRG_1_COMP_CR2], A
   pop A
   RAM_EPILOGUE RAM_USE_CLASS_2
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CMPPRG_1_SetRef
;
;  DESCRIPTION:
;    Sets comparator threshold at specified ratio between Low Limit and Vcc
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;   A contains reference value.
;     Ref values shown are for example
;     1.000  0 0 0 0
;     0.937  0 0 0 1
;     ....
;     0.500  0 1 1 1
;     ....
;     0.062  0 0 0 0
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 CMPPRG_1_SetRef:
_CMPPRG_1_SetRef:

   RAM_PROLOGUE RAM_USE_CLASS_2
   and  A, GAINMASK                             ; mask A to protect unchanged bits
   mov  X, SP                                   ; define temp store location
;
   push A                                       ; put reference value in temp store
   mov  A, reg[CMPPRG_1_COMP_CR0]                ; read old CR0 value
   and  A, ~REFMASK                             ; clear reference bits in A
   tst  [X],HIGHGAIN                            ; See if High Gain bit is set
   jnz  .SETHIGHGAIN
   and  reg[CMPPRG_1_COMP_CR3],~EXGAIN           ; Clear High Gain bit.
   or   A, [X]                                  ; combine gain value with balance of reg.
   mov  reg[CMPPRG_1_COMP_CR0], A                ; move complete value back to register
   pop  A
   RAM_EPILOGUE RAM_USE_CLASS_2
   ret

.SETHIGHGAIN:
   and  [X],HIGHGAINMASK                        ; Make sure we have a valid high gain
   or   A, [X]                                  ; combine ref value with balance of reg.
   mov  reg[CMPPRG_1_COMP_CR0], A       ; move complete value back to register
   or   reg[CMPPRG_1_COMP_CR3], EXGAIN           ; Set High Gain bit.
   pop  A
   RAM_EPILOGUE RAM_USE_CLASS_2
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CMPPRG_1_Stop
;
;  DESCRIPTION:
;    Removes power from analog block.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 CMPPRG_1_Stop:
_CMPPRG_1_Stop:

   RAM_PROLOGUE RAM_USE_CLASS_1
   and reg[CMPPRG_1_COMP_CR2], FCh
   RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

; End of File CMPPRG_1.asm
